/*! \file
**********************************************************************************
*Title:                         Discretix Certificate Handling Toolkit source file
*
* Filename:                     tlk_cert_types_ieee_1667.h 
*
* Project, Target, subsystem:   Certificate Handling Toolkit, OMA DRM
*
* Created:                      28.01.2008
*
* Modified:                     28.01.2008
*
* \Author                       Ira Boguslavsky
*
* \Remarks
*           Copyright (C) 2007 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/
#ifndef _TLK_CERT_TYPES_IEEE_1667_H_ 
#define _TLK_CERT_TYPES_IEEE_1667_H_
#ifdef __cplusplus
extern "C" {
#endif

#include "DX_VOS_BaseTypes.h"
#include "tlk_cert_types.h"

typedef enum
{
    TLK_CERT_1667_BEGIN         = 0,
    TLK_CERT_1667_CONTINUE      = 1,
    TLK_CERT_1667_FINAL         = 2,
    TLK_CERT_1667_SELF          = 3,

    TLK_CERT_1667_LAST_ACTION   = 0x7FFFFFFF
}TLK_CERT_1667_AuthAction_t;


typedef struct  _TLK_CERT_1667_CVPO_Part_t
{
    TLK_CERT_BufferOffest_t          subjectNameTR;
    TLK_CERT_BufferOffest_t          signatureTR;
    TLK_CERT_BufferOffest_t          subjectKeyIdentifierTR;   
    TLK_CERT_BufferOffest_t          subjectNameEE;    
    TLK_CERT_BufferOffest_t          subjectKeyIdentifierEE;
    TLK_CERT_BufferOffest_t          subjectPublicKeyInfoEE;
}TLK_CERT_1667_CPVO_Part_t;

typedef struct 
{
    DxUint32_t                       certificateBaseAddress;
    TLK_CERT_BufferOffest_t          signedData;
    TLK_CERT_BufferOffest_t          subjectName;
    TLK_CERT_BufferOffest_t          issuerName;
    TLK_CERT_BufferOffest_t          signature;
    TLK_CERT_RsaKey_t                subjectPublicKey;
    TLK_CERT_1667_CPVO_Part_t        cvpoPart;
    TLK_CERT_MacBuffer_t             mac;
}TLK_CERT_1667_ContextObj_t;

typedef struct _TLK_CERT_1667_CVPO_t
{
    TLK_CERT_1667_CPVO_Part_t        cvpoPart;
    TLK_CERT_MacBuffer_t             mac;
}TLK_CERT_1667_CPVO_t;

#ifdef __cplusplus
}
#endif
#endif
